/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;

public class chess
extends Applet
implements Runnable,
MouseListener {
    Thread t;
    static chess Chess = new chess();
    final int CASTLE_SHORT = 101;
    final int CASTLE_LONG = 102;
    final int PAWN_SINGLE_MOVE = 103;
    final int PAWN_DOUBLE_MOVE = 104;
    final int PAWN_CAPTURE_LEFT = 105;
    final int PAWN_CAPTURE_RIGHT = 106;
    final int PAWN_ENPASSANT = 107;
    final int WHITE = 0;
    final int BLACK = 1;
    final int FREE = 0;
    char[] pieceCodes = new char[]{'-', 'P', 'R', 'N', 'B', 'Q', 'K'};
    boolean[] pieceCanSlide = new boolean[]{false, false, true, false, true, true, false};
    String[] pieceNames = new String[]{"", "pawn", "rook", "knight", "bishop", "queen", "king"};
    int[] pieceValues = new int[]{0, 1, 5, 3, 3, 9, 1000};
    int[][] pieceDir = new int[][]{{0}, {103, 104, 105, 106}, {10, -1, 1, -10}, {12, 19, 21, 8, -8, -21, -19, -12}, {-9, -11, 9, 11}, {-9, -11, 9, 11, 10, -1, 1, -10}, {-9, -11, 9, 11, 10, -1, 1, -10, 101, 102}};
    static int[] Board = new int[100];
    int[] BoardInit = new int[]{99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 2, 3, 4, 6, 5, 4, 3, 2, 99, 99, 1, 1, 1, 1, 1, 1, 1, 1, 99, 99, 0, 0, 0, 0, 0, 0, 0, 0, 99, 99, 0, 0, 0, 0, 0, 0, 0, 0, 99, 99, 0, 0, 0, 0, 0, 0, 0, 0, 99, 99, 0, 0, 0, 0, 0, 0, 0, 0, 99, 99, -1, -1, -1, -1, -1, -1, -1, -1, 99, 99, -2, -3, -4, -6, -5, -4, -3, -2, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99};
    int[] AttackedSquares = new int[100];
    int[] From = new int[400];
    int[] To = new int[400];
    int[] Taken = new int[400];
    int[] Dir = new int[400];
    boolean[] Queened = new boolean[400];
    int[] Special = new int[400];
    int[] BsfFrom = new int[400];
    int[] BsfTo = new int[400];
    int[] BsfDir = new int[400];
    int[] BsfScore = new int[400];
    int[] BsfTaken = new int[400];
    final int HUMAN_TO_MOVE = 0;
    final int COMP_TO_MOVE = 1;
    final int FINISHED = 2;
    final int EXIT = 3;
    final int THINKING = 4;
    final int CHECKMATE = 5;
    final int STALEMATE = 6;
    int SideToMove = 0;
    int OtherSide = 1;
    int MinScore = -1000000;
    int MoveNumber = 0;
    int GameMode = 0;
    int TestMode = 0;
    boolean BlackCastled = false;
    boolean WhiteCastled = false;
    int NumInitialOptions = 0;
    int NumMovesSearched = 0;
    int MaxDepth = 0;
    int TimeTaken = 0;
    String DisplayMsg = "";
    String HumanMove = "";
    int MovedFrom = 0;
    int MovedTo = 0;
    int Level = 2;
    int[] LevelRnd = new int[]{20, 20, 10, 10, 5, 5};
    int[] LevelDepth = new int[]{1, 2, 3, 3, 3, 4};
    boolean[] LevelHysterisis = new boolean[]{false, false, false, false, true, false};
    Image OffScreenImage;
    Graphics og;
    Graphics g;
    Font Main_Font = new Font("Impact", 1, 28);
    Font Small_Font = new Font("TimesRoman", 2, 14);
    Font Tiny_Font = new Font("TimesRoman", 0, 12);
    Color colDarkGray = new Color(51, 51, 51);
    static int width = 740;
    static int height = 540;
    static int BoardOffset = 10;
    static int SqSize = 60;
    static Frame f;
    Image ImgBrain;
    Image ImgLightSq;
    Image ImgDarkSq;
    Image ImgBackground;
    Image[] ImgPieces = new Image[15];
    boolean WhiteOnTop = false;
    boolean ShowCoord = false;
    Color BoardTextCol = new Color(102, 102, 102);

    private Image findImage(String string) {
        URL uRL = this.getClass().getResource(string);
        Image image = Toolkit.getDefaultToolkit().getImage(uRL);
        return image;
    }

    private void startGame() {
        for (int i = 0; i < 100; ++i) {
            chess.Board[i] = this.BoardInit[i];
        }
        chess.Chess.GameMode = 0;
        this.SideToMove = 0;
        this.OtherSide = 1;
        this.MinScore = -1000000;
        this.MoveNumber = 0;
        chess.Chess.MovedFrom = 0;
        chess.Chess.MovedTo = 0;
        this.HumanMove = "";
    }

    @Override
    public void init() {
        this.t = new Thread(this);
        this.t.start();
        this.OffScreenImage = this.createImage(width, height);
        this.og = this.OffScreenImage.getGraphics();
        this.ImgLightSq = this.findImage("boardLight.png");
        this.ImgDarkSq = this.findImage("boardDark.png");
        this.ImgBrain = this.findImage("brain.png");
        this.ImgBackground = this.findImage("wood.png");
        this.ImgPieces[0] = this.findImage("bk.png");
        this.ImgPieces[1] = this.findImage("bq.png");
        this.ImgPieces[2] = this.findImage("bb.png");
        this.ImgPieces[3] = this.findImage("bn.png");
        this.ImgPieces[4] = this.findImage("br.png");
        this.ImgPieces[5] = this.findImage("bp.png");
        this.ImgPieces[6] = null;
        this.ImgPieces[7] = this.findImage("wp.png");
        this.ImgPieces[8] = this.findImage("wr.png");
        this.ImgPieces[9] = this.findImage("wn.png");
        this.ImgPieces[10] = this.findImage("wb.png");
        this.ImgPieces[11] = this.findImage("wq.png");
        this.ImgPieces[12] = this.findImage("wk.png");
        if (this.g == null) {
            this.g = this.getGraphics();
        }
        chess.Chess.Level = 2;
        this.addMouseListener(this);
    }

    private void badHumanMove(String string) {
        if (chess.Chess.HumanMove.length() == 0) {
            return;
        }
        chess.Chess.HumanMove = "";
        chess.Chess.MovedFrom = 0;
        chess.Chess.MovedTo = 0;
        chess.Chess.DisplayMsg = string;
        this.paint(this.g);
    }

    private boolean canKingBeTaken() {
        this.setAttackedSquares(this.SideToMove);
        for (int i = 11; i <= 88; ++i) {
            if (this.blackToMove() && Board[i] == 6) {
                return this.AttackedSquares[i] > 0;
            }
            if (!this.whiteToMove() || Board[i] != -6) continue;
            return this.AttackedSquares[i] > 0;
        }
        return false;
    }

    private boolean finished() {
        int n = Chess.findNextMove(0, 2, false, false, 0, null);
        if (this.NumInitialOptions == 0) {
            chess.Chess.GameMode = 6;
            chess.Chess.DisplayMsg = "Stalemate !";
            return true;
        }
        if (this.whiteToMove() && n < -50000 || this.blackToMove() && n > 50000) {
            chess.Chess.GameMode = 5;
            chess.Chess.DisplayMsg = "Checkmate !!!";
            return true;
        }
        return false;
    }

    private int findNextMove(int n, int n2, boolean bl, boolean bl2, int n3, Graphics graphics) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        double d = System.currentTimeMillis();
        String string = "";
        if (n == 0) {
            chess.Chess.NumInitialOptions = 0;
            chess.Chess.NumMovesSearched = 0;
            chess.Chess.MaxDepth = 0;
            if (bl) {
                System.out.println("=== Move " + this.MoveNumber + " " + (this.blackToMove() ? "Black" : "White") + " ===");
            }
        } else if (n > chess.Chess.MaxDepth) {
            chess.Chess.MaxDepth = n;
        }
        this.BsfFrom[this.MoveNumber] = 0;
        this.BsfTo[this.MoveNumber] = 0;
        this.BsfDir[this.MoveNumber] = 0;
        this.BsfTaken[this.MoveNumber] = 0;
        this.BsfScore[this.MoveNumber] = this.MinScore;
        if (n >= n2) {
            return this.scoreBoard();
        }
        n4 = this.nextPos();
        while (n4 > 0) {
            n5 = this.nextDir(n4);
            while (n5 > 0) {
                string = this.putOnMove(n4, n5);
                ++chess.Chess.NumMovesSearched;
                if (n == 0) {
                    ++chess.Chess.NumInitialOptions;
                }
                this.swapSides();
                if (this.canKingBeTaken()) {
                    this.swapSides();
                    this.takeOffMove();
                } else if (bl2) {
                    if (string.equals(chess.Chess.HumanMove)) {
                        if (chess.Chess.TestMode == 1) {
                            System.out.println(string);
                        }
                        return 0;
                    }
                    this.swapSides();
                    this.takeOffMove();
                } else {
                    n6 = this.findNextMove(n + 1, n2 + (this.LevelHysterisis[this.Level] && this.Taken[this.MoveNumber - 1] > 0 ? 1 : 0), false, false, 0, graphics);
                    if (n == 0) {
                        if (bl) {
                            System.out.println(string + " = " + n6);
                        }
                        if (n3 > 0 && graphics != null) {
                            graphics.setColor(this.BoardTextCol);
                            graphics.fillRect(570, 500, 100, 2);
                            graphics.setColor(Color.white);
                            graphics.fillRect(570, 500, chess.Chess.NumInitialOptions * 100 / n3, 2);
                            this.paint(graphics);
                        }
                    }
                    this.swapSides();
                    this.takeOffMove();
                    this.betterScore(n6);
                }
                n5 = this.nextDir(n4, n5);
            }
            n4 = this.nextPos(n4);
        }
        if (n == 0) {
            chess.Chess.TimeTaken = (int)((double)System.currentTimeMillis() - d);
        }
        if (bl2) {
            if (chess.Chess.HumanMove.length() > 0) {
                this.badHumanMove("Illegal move");
            }
            return 0;
        }
        return this.BsfScore[this.MoveNumber];
    }

    private void betterScore(int n) {
        if (this.whiteToMove() && n > this.BsfScore[this.MoveNumber] || this.blackToMove() && n < this.BsfScore[this.MoveNumber]) {
            this.BsfFrom[this.MoveNumber] = this.From[this.MoveNumber];
            this.BsfTo[this.MoveNumber] = this.To[this.MoveNumber];
            this.BsfDir[this.MoveNumber] = this.Dir[this.MoveNumber];
            this.BsfTaken[this.MoveNumber] = this.Taken[this.MoveNumber];
            this.BsfScore[this.MoveNumber] = n;
        }
    }

    private String gatherStats(int n) {
        String string = "";
        string = "#mv=" + chess.Chess.NumMovesSearched + " d=" + (chess.Chess.MaxDepth + 1);
        if (chess.Chess.TimeTaken > 0) {
            string = string + " mps=" + chess.Chess.NumMovesSearched / chess.Chess.TimeTaken + "k";
        }
        string = string + " s=" + n + " " + chess.Chess.TimeTaken / 1000 + "sec";
        return string;
    }

    private String getCoord(int n) {
        return "" + (char)(105 - n % 10) + Integer.toString(n / 10);
    }

    @Override
    public void paint(Graphics graphics) {
        long l = System.currentTimeMillis();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = BoardOffset;
        if (graphics == null || this.og == null) {
            return;
        }
        for (n3 = 0; n3 < width; n3 += this.ImgBackground.getWidth(this)) {
            for (n4 = 0; n4 < height; n4 += this.ImgBackground.getHeight(this)) {
                this.og.drawImage(this.ImgBackground, n3, n4, this);
            }
        }
        this.og.setColor(this.BoardTextCol);
        for (n4 = 0; n4 < 8; ++n4) {
            for (n3 = 0; n3 < 8; ++n3) {
                if (n4 % 2 == n3 % 2) {
                    this.og.drawImage(this.ImgLightSq, n3 * SqSize + n5, n4 * SqSize + n5, this);
                } else {
                    this.og.drawImage(this.ImgDarkSq, n3 * SqSize + n5, n4 * SqSize + n5, this);
                }
                n2 = (n4 + 1) * 10 + (n3 + 1);
                if (!this.WhiteOnTop) {
                    n2 = 99 - n2;
                }
                if (this.whitePiece(n2) || this.blackPiece(n2)) {
                    n = Board[n2];
                    this.og.drawImage(this.ImgPieces[n + 6], n3 * SqSize + n5, n4 * SqSize + n5, this);
                } else if (this.ShowCoord) {
                    this.og.setFont(this.Tiny_Font);
                    this.og.drawString("" + this.getCoord(n2), n3 * SqSize + n5 + 24, n4 * SqSize + n5 + 35);
                }
                if (n2 != chess.Chess.MovedFrom && n2 != chess.Chess.MovedTo) continue;
                this.og.drawRect(n3 * SqSize + 2 + n5, n4 * SqSize + 2 + n5, SqSize - 4, SqSize - 6);
            }
        }
        this.og.drawImage(Chess.blackToMove() ? this.ImgPieces[5] : this.ImgPieces[7], 504, 430, this);
        n3 = 570;
        n4 = 440;
        this.og.setColor(Color.white);
        this.og.fillRect(n3, n4, 30, 30);
        this.og.setColor(Color.black);
        if (!this.WhiteOnTop) {
            this.og.fillRect(n3, n4, 30, 15);
        } else {
            this.og.fillRect(n3, n4 + 15, 30, 15);
        }
        this.og.setColor(Color.black);
        this.og.drawRect(n3, n4, 30, 30);
        n3 = SqSize * 9;
        n4 = SqSize;
        this.og.setColor(this.colDarkGray);
        this.og.setFont(this.Main_Font);
        this.og.drawRect(n3, n4 + 10, 140, 40);
        this.og.drawString("Undo", n3 + 35, n4 + 40);
        this.og.drawRect(n3, (n4 += SqSize) + 10, 140, 40);
        this.og.drawString("Play", n3 + 40, n4 + 40);
        this.og.drawRect(n3, (n4 += SqSize) + 10, 140, 40);
        this.og.drawString("New Game", n3 + 4, n4 + 40);
        n4 += SqSize;
        this.og.drawString("48 hour chess", 520, 44);
        this.og.drawImage(this.ImgBrain, 665, 436, this);
        this.og.drawString("" + (chess.Chess.Level + 1), 710, 470);
        this.og.setFont(this.Small_Font);
        n4 = 270;
        n3 = 515;
        this.og.drawString("    I figured out how to write this", n3, n4);
        this.og.drawString("program one night over a couple", n3, n4 += 15);
        this.og.drawString("of beers and finished the program", n3, n4 += 15);
        this.og.drawString("2 days later. There are way better", n3, n4 += 15);
        this.og.drawString("chess programs out there but I'm", n3, n4 += 15);
        this.og.drawString("certain none of the others were", n3, n4 += 15);
        this.og.drawString("written in 48 hours.", n3, n4 += 15);
        this.og.drawString("        Mike Robinson @", n3, n4 += 25);
        this.og.drawString("              www.bikesandkites.com", n3, n4 += 15);
        this.og.drawString(chess.Chess.DisplayMsg, 610 - chess.Chess.DisplayMsg.length() * 3, 500);
        n3 = 620;
        n4 = 440;
        this.og.drawImage(this.ImgLightSq, n3, n4, n3 + 30, n4 + 30, 0, 0, 30, 30, this);
        this.og.setColor(Color.black);
        this.og.drawRect(n3, n4, 30, 30);
        this.og.drawString("e4", n3 + 10, n4 + 20);
        graphics.drawImage(this.OffScreenImage, 0, 0, this);
    }

    @Override
    public void run() {
        int n = 0;
        int n2 = 0;
        String string = "";
        this.startGame();
        while (chess.Chess.GameMode != 3) {
            if (chess.Chess.GameMode == 1) {
                chess.Chess.DisplayMsg = "";
                chess.Chess.GameMode = 4;
                this.paint(this.g);
                n2 = Chess.findNextMove(0, 1, chess.Chess.TestMode == 2, false, 0, this.g);
                n = chess.Chess.NumInitialOptions;
                n2 = Chess.findNextMove(0, this.LevelDepth[chess.Chess.Level], chess.Chess.TestMode == 2, false, n, this.g);
                chess.Chess.DisplayMsg = this.gatherStats(n2);
                if (chess.Chess.TestMode > 0) {
                    System.out.println("   " + chess.Chess.DisplayMsg);
                    System.out.println("");
                }
                string = Chess.putOnBestMove();
                if (chess.Chess.TestMode == 0) {
                    chess.Chess.DisplayMsg = string;
                }
                if (chess.Chess.TestMode == 1) {
                    System.out.println(string);
                }
                Chess.swapSides();
                if (!Chess.finished()) {
                    chess.Chess.GameMode = 0;
                }
                if (this.LevelDepth[chess.Chess.Level] <= 4) {
                    try {
                        Thread cfr_ignored_0 = chess.Chess.t;
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.paint(this.g);
            }
            try {
                Thread cfr_ignored_1 = chess.Chess.t;
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private boolean blackToMove() {
        return this.SideToMove == 1;
    }

    private boolean whiteToMove() {
        return this.SideToMove == 0;
    }

    private boolean onBoard(int n) {
        return n >= 11 && n <= 88 && Board[n] != 99;
    }

    private boolean freeSquare(int n) {
        if (!this.onBoard(n)) {
            return false;
        }
        return Board[n] == 0;
    }

    private boolean blackPiece(int n) {
        return Board[n] < 0;
    }

    private boolean whitePiece(int n) {
        return Board[n] > 0 && Board[n] < 10;
    }

    private boolean opoPiece(int n) {
        if (!this.onBoard(n)) {
            return false;
        }
        return this.whiteToMove() && this.blackPiece(n) || this.blackToMove() && this.whitePiece(n);
    }

    private boolean ourPiece(int n) {
        if (!this.onBoard(n)) {
            return false;
        }
        return this.blackToMove() && this.blackPiece(n) || this.whiteToMove() && this.whitePiece(n);
    }

    private boolean slidingPiece(int n) {
        return this.pieceCanSlide[Math.abs(n)];
    }

    private int nextPos() {
        return this.nextPos(10);
    }

    private int nextPos(int n) {
        for (int i = n + 1; i <= 88; ++i) {
            if (!this.ourPiece(i)) continue;
            return i;
        }
        return -1;
    }

    private int nextDir(int n) {
        int n2 = Math.abs(Board[n]);
        int n3 = this.pieceDir[n2].length - 1;
        n3 = this.slidingPiece(n2) ? n * 100 + this.pieceDir[n2].length - 1 : this.pieceDir[n2].length;
        return this.nextDir(n, n3);
    }

    private int nextDir(int n, int n2) {
        int n3 = Math.abs(Board[n]);
        int n4 = n2 / 100;
        int n5 = n2 % 100;
        int n6 = 0;
        if (this.slidingPiece(n3) && (n == n4 || this.freeSquare(n4)) && (this.freeSquare(n4 += (n6 = this.pieceDir[n3][n5])) || this.opoPiece(n4))) {
            return n4 * 100 + n5;
        }
        while (n5 > 0) {
            if (n3 < 0 || n3 >= this.pieceDir.length || --n5 >= this.pieceDir[n3].length) {
                System.out.println("Err1: pi=" + n3 + " d=" + n5 + " p=" + n);
                return 0;
            }
            n6 = this.pieceDir[n3][n5];
            if (n6 < 100) {
                n4 = n + n6;
                if (!this.freeSquare(n4) && !this.opoPiece(n4)) continue;
                return n4 * 100 + n5;
            }
            switch (n6) {
                case 101: {
                    if (this.whiteToMove() && this.freeSquare(12) && this.freeSquare(13) && Board[11] == 2 && Board[14] == 6 && !this.WhiteCastled) {
                        return 1100 + n5;
                    }
                    if (!this.blackToMove() || !this.freeSquare(82) || !this.freeSquare(83) || Board[81] != -2 || Board[84] != -6 || this.BlackCastled) break;
                    return 8100 + n5;
                }
                case 102: {
                    if (this.whiteToMove() && this.freeSquare(15) && this.freeSquare(16) && this.freeSquare(17) && Board[18] == 2 && Board[14] == 6 && !this.WhiteCastled) {
                        return 1800 + n5;
                    }
                    if (!this.blackToMove() || !this.freeSquare(87) || !this.freeSquare(86) || !this.freeSquare(85) || Board[88] != -2 || Board[84] != -6 || this.BlackCastled) break;
                    return 8800 + n5;
                }
                case 103: {
                    if (this.blackToMove() && this.freeSquare(n - 10)) {
                        return (n - 10) * 100 + n5;
                    }
                    if (!this.whiteToMove() || !this.freeSquare(n + 10)) break;
                    return (n + 10) * 100 + n5;
                }
                case 104: {
                    if (this.blackToMove() && n >= 71 && n <= 78 && this.freeSquare(n - 10) && this.freeSquare(n - 20)) {
                        return (n - 20) * 100 + n5;
                    }
                    if (!this.whiteToMove() || n < 21 || n > 28 || !this.freeSquare(n + 10) || !this.freeSquare(n + 20)) break;
                    return (n + 20) * 100 + n5;
                }
                case 105: {
                    if (this.blackToMove() && this.opoPiece(n - 11)) {
                        return (n - 11) * 100 + n5;
                    }
                    if (!this.whiteToMove() || !this.opoPiece(n + 9)) break;
                    return (n + 9) * 100 + n5;
                }
                case 106: {
                    if (this.blackToMove() && this.opoPiece(n - 9)) {
                        return (n - 9) * 100 + n5;
                    }
                    if (!this.whiteToMove() || !this.opoPiece(n + 11)) break;
                    return (n + 11) * 100 + n5;
                }
            }
        }
        return -1;
    }

    private String putOnMove(int n, int n2) {
        int n3 = Math.abs(Board[n]);
        int n4 = n2 / 100;
        int n5 = n2 % 100;
        int n6 = 0;
        if (!this.onBoard(n)) {
            return "";
        }
        n6 = this.pieceDir[n3][n5];
        String string = "";
        this.Queened[this.MoveNumber] = false;
        if (n6 >= 100) {
            switch (n6) {
                case 101: {
                    if (this.whiteToMove()) {
                        chess.Board[12] = Board[14];
                        chess.Board[13] = Board[11];
                        chess.Board[14] = 0;
                        chess.Board[11] = 0;
                        this.From[this.MoveNumber] = 14;
                        this.To[this.MoveNumber] = 12;
                        this.Taken[this.MoveNumber] = 0;
                        this.Dir[this.MoveNumber] = n2;
                        ++this.MoveNumber;
                        this.WhiteCastled = true;
                        return "Ke1-g1";
                    }
                    chess.Board[82] = Board[84];
                    chess.Board[83] = Board[81];
                    chess.Board[84] = 0;
                    chess.Board[81] = 0;
                    this.From[this.MoveNumber] = 84;
                    this.To[this.MoveNumber] = 82;
                    this.Taken[this.MoveNumber] = 0;
                    this.Dir[this.MoveNumber] = n2;
                    ++this.MoveNumber;
                    this.BlackCastled = true;
                    return "Ke8-g8";
                }
                case 102: {
                    if (this.whiteToMove()) {
                        chess.Board[16] = 6;
                        chess.Board[15] = 2;
                        chess.Board[14] = 0;
                        chess.Board[18] = 0;
                        this.From[this.MoveNumber] = 14;
                        this.To[this.MoveNumber] = 16;
                        this.Taken[this.MoveNumber] = 0;
                        this.Dir[this.MoveNumber] = n2;
                        ++this.MoveNumber;
                        this.WhiteCastled = true;
                        return "Ke1-c1";
                    }
                    chess.Board[86] = -6;
                    chess.Board[85] = -2;
                    chess.Board[84] = 0;
                    chess.Board[88] = 0;
                    this.From[this.MoveNumber] = 84;
                    this.To[this.MoveNumber] = 86;
                    this.Taken[this.MoveNumber] = 0;
                    this.Dir[this.MoveNumber] = n2;
                    ++this.MoveNumber;
                    this.BlackCastled = true;
                    return "Ke8-c8";
                }
                case 103: {
                    n4 = n + (this.blackToMove() ? -10 : 10);
                    break;
                }
                case 104: {
                    n4 = n + (this.blackToMove() ? -20 : 20);
                    break;
                }
                case 105: {
                    n4 = n + (this.blackToMove() ? -11 : 9);
                    break;
                }
                case 106: {
                    n4 = n + (this.blackToMove() ? -9 : 11);
                }
            }
            if (n6 == 103 || n6 == 105 || n6 == 106) {
                if (this.blackToMove() && n4 <= 18) {
                    chess.Board[n] = -5;
                    this.Queened[this.MoveNumber] = true;
                }
                if (this.whiteToMove() && n4 >= 81) {
                    chess.Board[n] = 5;
                    this.Queened[this.MoveNumber] = true;
                }
            }
        }
        this.From[this.MoveNumber] = n;
        this.To[this.MoveNumber] = n4;
        this.Taken[this.MoveNumber] = Board[n4];
        this.Dir[this.MoveNumber] = n2;
        chess.Board[n4] = Board[n];
        chess.Board[n] = 0;
        string = "" + this.pieceCodes[n3] + this.getCoord(n) + (this.Taken[this.MoveNumber] == 0 ? "-" : "*") + this.getCoord(n4);
        ++this.MoveNumber;
        return string;
    }

    private void takeOffMove() {
        --this.MoveNumber;
        int n = this.From[this.MoveNumber];
        int n2 = this.To[this.MoveNumber];
        int n3 = Board[n2];
        chess.Board[n] = Board[n2];
        chess.Board[n2] = this.Taken[this.MoveNumber];
        if (n3 == 6 && n == 14 && n2 == 12) {
            chess.Board[14] = 6;
            chess.Board[11] = 2;
            chess.Board[12] = 0;
            chess.Board[13] = 0;
            this.WhiteCastled = false;
        }
        if (n3 == -6 && n == 84 && n2 == 82) {
            chess.Board[81] = -2;
            chess.Board[84] = -6;
            chess.Board[82] = 0;
            chess.Board[83] = 0;
            this.BlackCastled = false;
        }
        if (n3 == 6 && n == 14 && n2 == 16) {
            chess.Board[14] = 6;
            chess.Board[18] = 2;
            chess.Board[16] = 0;
            chess.Board[15] = 0;
            this.WhiteCastled = false;
        }
        if (n3 == -6 && n == 84 && n2 == 86) {
            chess.Board[84] = -6;
            chess.Board[88] = -2;
            chess.Board[86] = 0;
            chess.Board[85] = 0;
            this.BlackCastled = false;
        }
        if (this.Queened[this.MoveNumber]) {
            chess.Board[this.From[this.MoveNumber]] = Board[this.From[this.MoveNumber]] < 0 ? -1 : 1;
        }
    }

    private void swapSides() {
        this.SideToMove = this.SideToMove == 0 ? 1 : 0;
        this.OtherSide = this.OtherSide == 0 ? 1 : 0;
        this.MinScore = -this.MinScore;
    }

    private void setAttackedSquares(int n) {
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        if (this.SideToMove != n) {
            this.swapSides();
            bl = true;
        }
        int n4 = this.nextPos();
        for (int i = 11; i <= 88; ++i) {
            this.AttackedSquares[i] = 0;
        }
        while (n4 > 0) {
            n2 = this.nextDir(n4);
            while (n2 > 0) {
                n3 = (n2 = this.nextDir(n4, n2)) / 100;
                if (!this.onBoard(n3)) continue;
                int n5 = n3;
                this.AttackedSquares[n5] = this.AttackedSquares[n5] + 1;
            }
            n4 = this.nextPos(n4);
        }
        if (bl) {
            this.swapSides();
        }
    }

    private String putOnBestMove() {
        int n = this.BsfFrom[this.MoveNumber];
        int n2 = this.BsfDir[this.MoveNumber];
        chess.Chess.MovedFrom = n;
        chess.Chess.MovedTo = this.BsfTo[this.MoveNumber];
        return this.putOnMove(n, n2);
    }

    private int scoreBoard() {
        int n;
        int n2 = 0;
        for (n = 11; n <= 88; ++n) {
            if (this.whitePiece(n)) {
                n2 += this.pieceValues[Board[n]] * 100;
            }
            if (this.blackPiece(n)) {
                n2 -= this.pieceValues[Math.abs(Board[n])] * 100;
            }
            if (Board[n] == 1 && Board[n - 10] == 1) {
                n2 -= 10;
            }
            if (Board[n] != -1 || Board[n - 10] != -1) continue;
            n2 += 10;
        }
        if (Board[24] == 0) {
            n2 += 10;
        }
        if (Board[25] == 0) {
            n2 += 10;
        }
        if (Board[74] == 0) {
            n2 -= 10;
        }
        if (Board[75] == 0) {
            n2 -= 10;
        }
        if (Board[33] == 3) {
            n2 += 8;
        }
        if (Board[36] == 3) {
            n2 += 8;
        }
        if (Board[63] == -3) {
            n2 -= 8;
        }
        if (Board[66] == -3) {
            n2 -= 8;
        }
        if (Board[13] != 4) {
            n2 += 5;
        }
        if (Board[16] != 4) {
            n2 += 5;
        }
        if (Board[83] != -4) {
            n2 -= 5;
        }
        if (Board[83] != -4) {
            n2 -= 5;
        }
        if (this.WhiteCastled) {
            n2 += 40;
        }
        if (this.BlackCastled) {
            n2 -= 40;
        }
        if (this.MoveNumber < 14) {
            if (Board[15] == 5) {
                n2 += 20;
            }
            if (Board[85] == -5) {
                n2 -= 20;
            }
        }
        this.setAttackedSquares(1);
        for (n = 11; n <= 48; ++n) {
            if (this.AttackedSquares[n] <= 0) continue;
            --n2;
            if ((n < 43 || n > 46) && (n < 33 || n > 36)) continue;
            --n2;
        }
        this.setAttackedSquares(0);
        for (n = 51; n <= 88; ++n) {
            if (this.AttackedSquares[n] <= 0) continue;
            ++n2;
            if ((n < 53 || n > 56) && (n < 63 || n > 66)) continue;
            ++n2;
        }
        n2 += (int)(Math.random() * (double)this.LevelRnd[chess.Chess.Level]);
        if (this.MoveNumber < 12) {
            n2 += (int)(Math.random() * 10.0);
        }
        return n2;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        int n = (mouseEvent.getX() - BoardOffset) / 60 + 1;
        int n2 = (mouseEvent.getY() - BoardOffset) / 60 + 1;
        int n3 = n2 * 10 + n;
        int n4 = 0;
        if (chess.Chess.TestMode == 1) {
            System.out.println("x=" + mouseEvent.getX() + " y=" + mouseEvent.getY());
        }
        if (chess.Chess.GameMode != 0 && chess.Chess.GameMode != 6 && chess.Chess.GameMode != 5) {
            return;
        }
        chess.Chess.DisplayMsg = "";
        if (n >= 10) {
            if (n2 == 2 && chess.Chess.MoveNumber > 0) {
                Chess.takeOffMove();
                Chess.swapSides();
                chess.Chess.GameMode = 0;
                this.paint(this.g);
            } else if (n2 == 3 && chess.Chess.GameMode == 0) {
                Chess.getClass();
                chess.Chess.GameMode = 1;
                this.paint(this.g);
            } else if (n2 == 4) {
                Chess.startGame();
                this.paint(this.g);
            } else if (n2 == 5) {
                chess.Chess.TestMode = (chess.Chess.TestMode + 1) % 3;
                chess.Chess.DisplayMsg = "Test mode " + chess.Chess.TestMode;
                this.paint(this.g);
            } else if (n2 == 8) {
                if (mouseEvent.getX() < 600) {
                    this.WhiteOnTop = !this.WhiteOnTop;
                } else if (mouseEvent.getX() > 665) {
                    chess.Chess.Level = (chess.Chess.Level + 1) % this.LevelDepth.length;
                } else {
                    this.ShowCoord = !this.ShowCoord;
                }
                this.paint(this.g);
            }
            return;
        }
        if (!this.WhiteOnTop) {
            n3 = 99 - n3;
        }
        if (chess.Chess.GameMode == 0 && Chess.onBoard(n3)) {
            if (Chess.ourPiece(n3)) {
                n4 = Math.abs(Board[n3]);
                chess.Chess.HumanMove = "" + this.pieceCodes[n4] + this.getCoord(n3);
                chess.Chess.MovedFrom = n3;
                chess.Chess.MovedTo = 0;
                this.paint(this.g);
            } else if (chess.Chess.HumanMove.length() == 0) {
                this.badHumanMove("Click your piece first");
            } else {
                chess.Chess.HumanMove = chess.Chess.HumanMove + (Chess.opoPiece(n3) ? "*" : "-") + this.getCoord(n3);
                chess.Chess.MovedTo = n3;
                Chess.findNextMove(0, 1, false, true, 0, this.g);
                if (chess.Chess.MovedTo > 0 && !Chess.finished()) {
                    chess.Chess.GameMode = 1;
                }
                chess.Chess.HumanMove = "";
                this.paint(this.g);
            }
        }
    }
}

