import java.awt.*;
import java.applet.*;
import java.text.*;
import java.awt.event.*;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.applet.AudioClip;
import java.net.URL;
import java.io.*;
import sun.audio.*;
import java.awt.image.*;
import java.applet.Applet;
import javax.sound.sampled.*;

/*
 * Chess
 * 	2010-May-28
 * Copyright 
 * 	Michael Robinson - London, UK
 * 	www.bikesandkites.com
 * History
 * 	spent evening thinking about a data driven approach to chess
 * 	decide inventor of chess did not like computer programmers
 * 	3 hours could list moves available
 * 	5 hours : playing first move found for both sides
 * 	6 hours : min max
 * 	8 hours : improved scoring
 * 	9 hours : applet
 * 	11 hours : human moves alled
 * 	15 hours : released
 * To do:
 * 	reflect board
 * 	non cache
 * 	finish not based on our attacks too
 * 	not move into checkmate
 * 	check king not attacked
 * 	allow castling - not moved k and no sq under attack
 * 	bonus if cannot castle
 * 	en passant
 * 	alpha beta
 * 	sound
 * 	exchange when ahead
 * 	pawn structures - chains, number of
 * 	eval - development, pawn struct, castled
 * 	extend on capture
 * 	time based
 * Application
 * 	javac chess.java
 *	jar -cfm chess.jar Manifest.txt *.class *.png
 *	appletviewer index.html
 *	java -jar othello.jar
 * 	
 * To compile: 
 * 	cd C:\Java\othello
 * 	javac othello.java
 * 	javac -source 1.5 -target 1.5 othello.java
 *	jar -cfm othello.jar Manifest.txt *.class *.png
 *	jar -tf othello.jar
 * 	javac othello.java 2>tmp.log
 * 	java -jar othello.jar
 * 	appletviewer index.html
 *
 *	transfer all files to server
 *	<applet code=othello
 *	        width=720 height=510>
 *	</applet>
 */
public class chess extends Applet implements Runnable, MouseListener {
	Thread t;
	static chess Chess = new chess();
	
	final int CASTLE_SHORT = 101;
	final int CASTLE_LONG = 102;
	final int PAWN_SINGLE_MOVE = 103;
	final int PAWN_DOUBLE_MOVE = 104;
	final int PAWN_CAPTURE_LEFT = 105;
	final int PAWN_CAPTURE_RIGHT = 106;
	final int PAWN_ENPASSANT = 107;
	final int WHITE = 0;
	final int BLACK = 1;
	final int FREE = 0;

	char pieceCodes[] = { '-','P','R','N','B','Q','K' };
	boolean pieceCanSlide[] = { false,false,true,false,true,true,false };
	String pieceNames[] = { "","pawn","rook","knight","bishop","queen","king" };
	int pieceValues[] = { 0,1,5,3,3,9,1000 };
	int pieceDir[][] = {	{ 0 },
				{ PAWN_SINGLE_MOVE, PAWN_DOUBLE_MOVE, PAWN_CAPTURE_LEFT, PAWN_CAPTURE_RIGHT }, // pawn
				{ 10, -1, 1, -10 },			// rook
				{ 12, 19, 21, 8, -8, -21, -19, -12 },	// knight
				{ -9, -11, 9, 11 },			// bishop
				{ -9, -11, 9, 11, 10, -1, 1, -10 },	// queen
				{ -9, -11, 9, 11, 10, -1, 1, -10, CASTLE_SHORT, CASTLE_LONG }	// king
			};

	// single border around board - better to have double border
	// 99 marks illegal square
	// real board between 11 and 88
	static int Board[] = new int[100];

	int BoardInit[] = {
		99,	99,	99,	99,	99,	99,	99,	99,	99,	99,	
		99,	2,	3,	4,	6,	5,	4,	3,	2,	99,
		99,	1,	1,	1,	1,	1,	1,	1,	1,	99,
		99,	0,	0,	0,	0,	0,	0,	0,	0,	99,
		99,	0,	0,	0,	0,	0,	0,	0,	0,	99,
		99,	0,	0,	0,	0,	0,	0,	0,	0,	99,
		99,	0,	0,	0,	0,	0,	0,	0,	0,	99,
		99,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,	99,
		99,	-2,	-3,	-4,	-6,	-5,	-4,	-3,	-2,	99,
		99,	99,	99,	99,	99,	99,	99,	99,	99,	99
		};

	int AttackedSquares[] = new int[100];

	// moves
	int From[] = new int[400];
	int To[] = new int[400];
	int Taken[] = new int[400];
	int Dir[] = new int[400];
	boolean Queened[] = new boolean[400];
	int Special[] = new int[400];

	// scoring
	int BsfFrom[] = new int[400];
	int BsfTo[] = new int[400];
	int BsfDir[] = new int[400];
	int BsfScore[] = new int[400];
	int BsfTaken[] = new int[400];

	final int HUMAN_TO_MOVE = 0;
	final int COMP_TO_MOVE = 1;
	final int FINISHED = 2;
	final int EXIT = 3;
	final int THINKING = 4;
	final int CHECKMATE = 5;
	final int STALEMATE = 6;

	// play var
	int SideToMove = WHITE;
	int OtherSide = BLACK;
	int MinScore = -1000000;
	int MoveNumber = 0;
	int GameMode = HUMAN_TO_MOVE;
	int TestMode = 0;
	boolean BlackCastled = false;
	boolean WhiteCastled = false;
	int NumInitialOptions = 0;
	int NumMovesSearched = 0;
	int MaxDepth = 0;
	int TimeTaken = 0;
	String DisplayMsg = "";
	String HumanMove = "";
	int MovedFrom = 0;
	int MovedTo = 0;

	// level settings
	int Level = 2;
	int[] LevelRnd = { 20,20,10,10,5,5 };
	int[] LevelDepth = { 1,2,3,3,3,4 };
	boolean[] LevelHysterisis = { false,false,false,false,true,false };

	// graphic stuff
	Image OffScreenImage;
	Graphics og;
	Graphics g;
	Font Main_Font = new Font("Impact", Font.BOLD, 28);
	Font Small_Font = new Font("TimesRoman", Font.ITALIC, 14);
	Font Tiny_Font = new Font("TimesRoman", Font.PLAIN, 12);
	Color colDarkGray = new Color(51, 51, 51 );
	static int width=740;
	static int height=540;
	static int BoardOffset = 10;
	static int SqSize = 60;
	static Frame f;
	Image ImgBrain;
	Image ImgLightSq;
	Image ImgDarkSq;
	Image ImgBackground;
	Image ImgPieces[] = new Image[15];
	boolean WhiteOnTop = false;
	boolean ShowCoord = false;
	Color BoardTextCol = new Color( 102,102,102 );

	/*************************************
	** Applet methods
	*************************************/
	private Image findImage( String name ) {
		URL urlResource = getClass().getResource( name );
		Image imgRes = Toolkit.getDefaultToolkit().getImage( urlResource );
		return imgRes;
 	}

	private void startGame( ) {
		for( int i=0; i<100; i++ ) {
			Board[i] = BoardInit[i];
		}

		Chess.GameMode = HUMAN_TO_MOVE;
		SideToMove=WHITE;
		OtherSide = BLACK;
		MinScore = -1000000;
		MoveNumber = 0;
		Chess.MovedFrom = 0;
		Chess.MovedTo = 0;
		HumanMove = "";
	}

	public void init() {
		t = new Thread(this);
		t.start();

		OffScreenImage = createImage(width, height);
		og = OffScreenImage.getGraphics();

		// get images
		ImgLightSq = findImage( "boardLight.png" );
		ImgDarkSq = findImage( "boardDark.png" );
		ImgBrain = findImage( "brain.png" );
		ImgBackground = findImage( "wood.png" );
		
		// piece images img idx=piece+6
		ImgPieces[0] = findImage( "bk.png" );
		ImgPieces[1] = findImage( "bq.png" );
		ImgPieces[2] = findImage( "bb.png" );
		ImgPieces[3] = findImage( "bn.png" );
		ImgPieces[4] = findImage( "br.png" );
		ImgPieces[5] = findImage( "bp.png" );
		ImgPieces[6] = null;
		ImgPieces[7] = findImage( "wp.png" );
		ImgPieces[8] = findImage( "wr.png" );
		ImgPieces[9] = findImage( "wn.png" );
		ImgPieces[10] = findImage( "wb.png" );
		ImgPieces[11] = findImage( "wq.png" );
		ImgPieces[12] = findImage( "wk.png" );

		if ( g == null ) { g = this.getGraphics(); }
		Chess.Level = 2;

		addMouseListener(this);
	}

	private void badHumanMove( String msg ) {
		if ( Chess.HumanMove.length() == 0 ) { return; }

		Chess.HumanMove = "";
		Chess.MovedFrom = 0;
		Chess.MovedTo = 0;
		Chess.DisplayMsg = msg;
		paint(g);
	}

	private boolean canKingBeTaken( ) {
		// looking atopo side so see what sq he attacks
		setAttackedSquares( SideToMove );

		// is our king attacked
		for( int p=11; p<=88; p++ ) {
			if ( blackToMove() && Board[p] == 6 ) {
				return AttackedSquares[p] > 0;
			}
			if ( whiteToMove() && Board[p] == -6 ) {
				return AttackedSquares[p] > 0;
			}
		}

		// shouldn't get here but
		return false;
	}

	private boolean finished( ) {
		// can we take his king no matter what he does
		int score = Chess.findNextMove(0,2,false,false,0,null);

		if ( NumInitialOptions == 0 ) {
			Chess.GameMode = STALEMATE;
			Chess.DisplayMsg = "Stalemate !";
			return true;
		} else if ( whiteToMove() && score < -50000 || blackToMove() && score > 50000 ) {
			Chess.GameMode = CHECKMATE;
			Chess.DisplayMsg = "Checkmate !!!";
			return true;
		} else {
			return false;
		}
	}

	private int findNextMove( int level, int max_level, boolean show_stats, 
			boolean doing_human_move, int show_pct,Graphics g ) {
		int p = 0;
		int d = 0;
		int score = 0;
		double timeStart = System.currentTimeMillis();
		String moveStr = "";

		if ( level == 0 ) { 
			Chess.NumInitialOptions = 0;
			Chess.NumMovesSearched = 0;
			Chess.MaxDepth = 0;
			if ( show_stats ) {
				System.out.println("=== Move "+MoveNumber+" "+
					(blackToMove()?"Black":"White")+ " ===");
			}
		} else if ( level > Chess.MaxDepth ) { 
			Chess.MaxDepth = level; 
		}

		// init bsf
		BsfFrom[MoveNumber] = 0;
		BsfTo[MoveNumber] = 0;
		BsfDir[MoveNumber] = 0;
		BsfTaken[MoveNumber] = 0;
		BsfScore[MoveNumber] = MinScore;

		if ( level >= max_level ) { return scoreBoard(); }

		p = nextPos( );

		while( p > 0 ) {
			d = nextDir( p );

			while( d > 0 ) {

				moveStr = putOnMove( p,d );
				Chess.NumMovesSearched++;
				if ( level == 0 ) { Chess.NumInitialOptions++; }

				swapSides();

				if ( canKingBeTaken( ) ) {
					// bad move then
					swapSides();
					takeOffMove();
				} else if ( doing_human_move ) {
					// if looking for human move
					if ( moveStr.equals( Chess.HumanMove ) ) {
						if ( Chess.TestMode == 1 ) { System.out.println( moveStr ); }
						return 0;
					} else {
						swapSides();
						takeOffMove();
					}
				} else {
					// go up level but if using hysterisis and just taken go step further
					score = findNextMove( level + 1, 
						max_level + ( LevelHysterisis[Level] && Taken[MoveNumber-1]>0 ? 1:0 ),
					       	false, false,0,g );
	
					// test info
					if ( level == 0 ) {
						if ( show_stats ) { System.out.println(moveStr+" = "+score); }

						// progress bar
						if ( show_pct > 0 && g != null ) {
							g.setColor(BoardTextCol);
							g.fillRect( 570,500,100,2 );
							g.setColor(Color.white);
							g.fillRect( 570,500,(Chess.NumInitialOptions*100)/show_pct,2 );
							paint(g);
						}
					}

					swapSides();
					takeOffMove();
					betterScore( score );
				}

				d = nextDir( p,d );
			}

			p = nextPos(p);
		}

		// time taken ms
		if ( level == 0 ) { Chess.TimeTaken = (int) (System.currentTimeMillis() - timeStart); }

		// if no move found for human
		if ( doing_human_move ) {
			if ( Chess.HumanMove.length() > 0 ) {
				badHumanMove( "Illegal move" );
			}
			return 0;
		}

		return BsfScore[MoveNumber];
	}

	private void betterScore( int score ) {
		if (	whiteToMove() && score > BsfScore[MoveNumber]
			|| blackToMove() && score < BsfScore[MoveNumber] ) {

			BsfFrom[MoveNumber] = From[MoveNumber];
			BsfTo[MoveNumber] = To[MoveNumber];
			BsfDir[MoveNumber] = Dir[MoveNumber];
			BsfTaken[MoveNumber] = Taken[MoveNumber];
			BsfScore[MoveNumber] = score;
		}
	}

	private String gatherStats( int score ) {
		String str = "";
		
		str = "#mv="+ Chess.NumMovesSearched + " d="+(Chess.MaxDepth+1);
		if ( Chess.TimeTaken > 0 ) { str += " mps=" + ( Chess.NumMovesSearched / Chess.TimeTaken ) + "k"; }
		str += " s="+score+ " " + (Chess.TimeTaken/1000) + "sec";

		return str;
	}

	private String getCoord( int p ) {
		return "" + (char)(105 - (p%10)) + Integer.toString( (p/10) );
	}

	public void paint(Graphics g) {
		long startTime = System.currentTimeMillis();
		int piece = 0;
		int p = 0;
		int x = 0;
		int y = 0;
		int bo = BoardOffset;

		// if graphics not set up yet
		if ( g == null || og == null ) { return; }

		// background
		for ( x = 0; x < width; x+=ImgBackground.getWidth(this) ) {
			for ( y = 0; y < height; y+=ImgBackground.getHeight(this) ) {
				og.drawImage(ImgBackground, x,y,this );
			}
		}

		// draw board
		og.setColor(BoardTextCol);
		for( y=0;y<8;y++ ) {
			for( x=0;x<8;x++ ) {
				if ( y%2 == x%2 ) {
					og.drawImage( ImgLightSq, x*SqSize+bo, y*SqSize+bo, this );
				} else {
					og.drawImage( ImgDarkSq, x*SqSize+bo, y*SqSize+bo, this );
				}

				p = (y+1)*10 + (x+1);
				if ( ! WhiteOnTop ) { p = 99 - p; }

				// show piece image
				if ( whitePiece(p) || blackPiece(p) ) {
					piece = Board[p];
					og.drawImage( ImgPieces[piece+6], x*SqSize+bo, y*SqSize+bo, this );
				} else if ( ShowCoord ) {
					og.setFont( Tiny_Font );
					og.drawString( "" + getCoord(p), x*SqSize+bo+24, y*SqSize+bo+35 );
				}

				// tmp issue when reversed
				// highlighting
				if ( p == Chess.MovedFrom || p == Chess.MovedTo ) {
					og.drawRect( x*SqSize+2+bo, y*SqSize+2+bo, SqSize-4, SqSize-6 );
				}

			}
		}

		// show who to move
		og.drawImage( (Chess.blackToMove() ? ImgPieces[5] : ImgPieces[7]), 504, 430, this );


		// orientation
		x = 570;
		y = 440;
		og.setColor(Color.white);
		og.fillRect( x, y, 30, 30 );
		og.setColor(Color.black);
		if ( ! WhiteOnTop ) {
			og.fillRect( x, y, 30, 15 );
		} else {
			og.fillRect( x, y + 15, 30, 15 );
		}
		og.setColor(Color.black);
		og.drawRect( x, y, 30, 30 );

		x = SqSize*9;
		y = SqSize;

		// buttons
		og.setColor(colDarkGray);
		og.setFont( Main_Font );
		og.drawRect( x,y + 10,140,40 );
		og.drawString( "Undo", x+35,y+40 );
		y+=SqSize;

		og.drawRect( x,y + 10,140,40 );
		og.drawString( "Play", x+40,y+40 );
		y+=SqSize;

		og.drawRect( x,y + 10,140,40 );
		og.drawString( "New Game", x+4,y+40 );
		y+=SqSize;

		// show title
		og.drawString( "48 hour chess", 520,44 );

		// show level
		og.drawImage( ImgBrain, 665, 436, this );
		og.drawString( "" + (Chess.Level + 1), 710, 470 );

		// info
		og.setFont( Small_Font );
		y=270;
		x=515;
		og.drawString( "    I figured out how to write this", x,y );
		y+=15;
		og.drawString( "program one night over a couple", x,y );
		y+=15;
		og.drawString( "of beers and finished the program", x,y );
		y+=15;
		og.drawString( "2 days later. There are way better", x,y );
		y+=15;
		og.drawString( "chess programs out there but I'm", x,y );
		y+=15;
		og.drawString( "certain none of the others were", x,y );
		y+=15;
		og.drawString( "written in 48 hours.", x,y );
		y+=25;
		og.drawString( "        Mike Robinson @", x,y );
		y+=15;
		og.drawString( "              www.bikesandkites.com", x,y );

		// msg
		og.drawString( Chess.DisplayMsg, 610 - Chess.DisplayMsg.length()*3, 500 );

		// coords
		x = 620;
		y = 440;
		og.drawImage( ImgLightSq, x,y,x+30,y+30, 0,0,30,30,this );
		og.setColor(Color.black);
		og.drawRect( x, y, 30, 30 );
		og.drawString( "e4", x + 10, y+20 );

		// move offscreen image to front screen
		g.drawImage(OffScreenImage, 0, 0, this);
	}

	public void run() {
		int c = 0;
		int score = 0;
		String moveStr = "";

		startGame();

		while( Chess.GameMode != EXIT ) {

			if ( Chess.GameMode == COMP_TO_MOVE ) {
				Chess.DisplayMsg = "";
				Chess.GameMode = THINKING;
				paint(g);

				// get num initial options
				score = Chess.findNextMove(0,1, Chess.TestMode==2, false, 0,g );
				c = Chess.NumInitialOptions;
				score = Chess.findNextMove(0,LevelDepth[Chess.Level], Chess.TestMode==2, false, c,g );
				Chess.DisplayMsg = gatherStats( score );

				if ( Chess.TestMode > 0 ) {
					System.out.println("   " + Chess.DisplayMsg);
					System.out.println("");
				}

				moveStr = Chess.putOnBestMove( );

				if ( Chess.TestMode == 0 ) { Chess.DisplayMsg = moveStr; }
				if ( Chess.TestMode == 1 ) { System.out.println( moveStr ); }
				Chess.swapSides();
				if ( ! Chess.finished() ) { Chess.GameMode = HUMAN_TO_MOVE; }

				// wait 1/2 sec on lower levels
				if ( LevelDepth[Chess.Level] <= 4 ) { 
					try { Chess.t.sleep(500); } catch (InterruptedException f) { ; } 
				}
				paint(g);
			}

			// wait a while
			try { Chess.t.sleep(100); } catch (InterruptedException f) { ; }
		}
	}

	private boolean blackToMove() {
		return ( SideToMove == BLACK );
	}

	private boolean whiteToMove() {
		return ( SideToMove == WHITE );
	}

	private boolean onBoard( int sq ) {
		return	sq >= 11 && sq <= 88 && Board[sq] != 99;
	}

	private boolean freeSquare( int sq ) {
		if ( ! onBoard(sq ) ) { return false; }
		return ( Board[ sq ] == 0 );
	}

	private boolean blackPiece( int sq ) {
		return Board[ sq ] < 0;
	}

	private boolean whitePiece( int sq ) {
		return Board[ sq ] > 0 && Board[ sq ] < 10;
	}

	private boolean opoPiece( int sq ) {
		if ( ! onBoard(sq ) ) { return false; }
		return	whiteToMove() && blackPiece(sq)
			|| blackToMove() && whitePiece(sq);
	}

	private boolean ourPiece( int sq ) {
		if ( ! onBoard(sq ) ) { return false; }
		return	blackToMove() && blackPiece(sq)
			|| whiteToMove() && whitePiece(sq);
	}

	private boolean slidingPiece( int p ) {
		return pieceCanSlide[ Math.abs( p ) ];
	}

	private int nextPos( ) {
		return nextPos( 10 );
	}

	private int nextPos( int init_p ) {
		for( int p=init_p + 1; p<=88; p++ ) {
			if ( ourPiece( p ) ) { return p; }
		}

		return -1;
	}

	private int nextDir( int p ) {
		int piece = Math.abs( Board[ p ] );
		int d = pieceDir[ piece ].length -1;

		if ( slidingPiece( piece ) ) {
			d = p* 100 + pieceDir[ piece ].length -1;
		} else {
			d = pieceDir[ piece ].length;
		}

		return nextDir( p, d  );
	}

	private int nextDir( int p, int init_d ) {
		int piece = Math.abs( Board[ p ] );
		int to = init_d / 100;
		int d = init_d % 100;
		int dir = 0;

		if ( slidingPiece( piece ) && ( p == to || freeSquare(to) ) ) {
			dir = pieceDir[piece][d];
			to += dir;
			if ( freeSquare(to) || opoPiece(to) ) {
				return to*100 + d;
			}
		}

		while( d > 0 ) {
			d--;
			// tmp
			if ( piece<0 || piece>=pieceDir.length || d >= pieceDir[piece].length ) {
				System.out.println("Err1: pi="+piece+" d="+d+" p="+p);
				return 0;
			}
			dir = pieceDir[piece][d];

			if ( dir < 100 ) {
				to = p + dir;

				if ( freeSquare(to) || opoPiece(to) ) {
					return to*100 + d;
				}
			} else {
				switch( dir ) {
					case CASTLE_SHORT:
						if (	whiteToMove() && freeSquare(12) && freeSquare(13) 
							&& Board[11] == 2 && Board[14] == 6
							&& ! WhiteCastled  ) {
							return( 1100 + d ); 
						}
						if (	blackToMove() && freeSquare(82) && freeSquare(83) 
							&& Board[81] == -2 && Board[84] == -6
							&& ! BlackCastled  ) {
							return( 8100 + d ); 
						}
						break;
					case CASTLE_LONG:
						if (	whiteToMove() && freeSquare(15) && freeSquare(16) && freeSquare(17) 
							&& Board[18] == 2 && Board[14] == 6
							&& ! WhiteCastled  ) {
							return( 1800 + d ); 
						}
						if (	blackToMove() && freeSquare(87) && freeSquare(86) && freeSquare(85) 
							&& Board[88] == -2 && Board[84] == -6
							&& ! BlackCastled  ) {
							return( 8800 + d ); 
						}
						break;
					case PAWN_SINGLE_MOVE:
						if ( blackToMove() && freeSquare(p-10) ) { return (p-10)*100 + d; }
						if ( whiteToMove() && freeSquare(p+10) ) { return (p+10)*100 + d; }
						break;
					case PAWN_DOUBLE_MOVE:
						if (	blackToMove() 
							&& p >= 71 && p <= 78 
							&& freeSquare(p-10) && freeSquare(p-20) ) { 
							return (p-20)*100 + d;
						}
						if (	whiteToMove() 
							&& p >= 21 && p <= 28 
							&& freeSquare(p+10) && freeSquare(p+20) ) { 
							return (p+20)*100 + d;
						}
						break;
					case PAWN_CAPTURE_LEFT:
						if ( blackToMove() && opoPiece(p-11) ) { return (p-11)*100 + d; }
						if ( whiteToMove() && opoPiece(p+9) ) { return (p+9)*100 + d; }
						break;
					case PAWN_CAPTURE_RIGHT:
						if ( blackToMove() && opoPiece(p-9) ) { return (p-9)*100 + d; }
						if ( whiteToMove() && opoPiece(p+11) ) { return (p+11)*100 + d; }
						break;
				}
			}
		}

		return -1;
	}

	private String putOnMove( int p, int init_d ) {
		int piece = Math.abs( Board[ p ] );
		int to = init_d/100;
		int d = init_d % 100;
		int dir = 0;

		if ( ! onBoard(p) ) { return ""; }

		dir = pieceDir[piece][d];
		String moveStr = "";
		Queened[MoveNumber] = false;

		// special 101...???
		if ( dir >= 100 ) {
			switch( dir ) {
				case CASTLE_SHORT:
					if ( whiteToMove() ) { 
						Board[12] = Board[14];
						Board[13] = Board[11];
						Board[14] = FREE;
						Board[11] = FREE;

						// store move
						From[MoveNumber] = 14;
						To[MoveNumber] = 12;
						Taken[MoveNumber] = FREE;
						Dir[MoveNumber] = init_d;
						MoveNumber++;
						WhiteCastled = true;
						return "Ke1-g1";
					} else {
						Board[82] = Board[84];
						Board[83] = Board[81];
						Board[84] = FREE;
						Board[81] = FREE;

						// store move
						From[MoveNumber] = 84;
						To[MoveNumber] = 82;
						Taken[MoveNumber] = FREE;
						Dir[MoveNumber] = init_d;
						MoveNumber++;
						BlackCastled = true;
						return "Ke8-g8";
					}
				case CASTLE_LONG:
					if ( whiteToMove() ) { 
						Board[16] = 6;
						Board[15] = 2;
						Board[14] = FREE;
						Board[18] = FREE;

						// store move
						From[MoveNumber] = 14;
						To[MoveNumber] = 16;
						Taken[MoveNumber] = FREE;
						Dir[MoveNumber] = init_d;
						MoveNumber++;
						WhiteCastled = true;
						return "Ke1-c1";
					} else {
						Board[86] = -6;
						Board[85] = -2;
						Board[84] = FREE;
						Board[88] = FREE;

						// store move
						From[MoveNumber] = 84;
						To[MoveNumber] = 86;
						Taken[MoveNumber] = FREE;
						Dir[MoveNumber] = init_d;
						MoveNumber++;
						BlackCastled = true;
						return "Ke8-c8";
					}
				case PAWN_SINGLE_MOVE:
					to = p + (blackToMove()? -10:10);
					break;
				case PAWN_DOUBLE_MOVE:
					to = p + (blackToMove()? -20:20);
					break;
				case PAWN_CAPTURE_LEFT:
					to = p + (blackToMove()? -11:9);
					break;
				case PAWN_CAPTURE_RIGHT:
					to = p + (blackToMove()? -9:11);
					break;
				// tmp en passant
			}

			// new queen?
			if ( dir == PAWN_SINGLE_MOVE || dir == PAWN_CAPTURE_LEFT || dir == PAWN_CAPTURE_RIGHT ) {
				if ( blackToMove() && to <= 18 ) { 
					Board[p] = -5;
					Queened[MoveNumber] = true;
				}
				if ( whiteToMove() && to >= 81 ) { 
					Board[p] = 5;
					Queened[MoveNumber] = true;
				}
			}
		}

		// store move
		From[MoveNumber] = p;
		To[MoveNumber] = to;
		Taken[MoveNumber] = Board[to];
		Dir[MoveNumber] = init_d;

		// alter board
		Board[to] = Board[p];
		Board[p] = FREE;

		moveStr = "" + pieceCodes[piece] + getCoord(p) + (Taken[MoveNumber] == 0 ? "-":"*") + getCoord(to);
		MoveNumber ++;

		return moveStr;
	}

	private void takeOffMove( ) {
		MoveNumber --;
		int from = From[MoveNumber];
		int to = To[MoveNumber];
		int piece = Board[to];

		Board[from] = Board[to];
		Board[to] = Taken[MoveNumber];

		// undo short castle white
		if ( piece == 6 && from == 14 && to == 12 ) {
			Board[14] = 6;
			Board[11] = 2;
			Board[12] = FREE;
			Board[13] = FREE;
			WhiteCastled = false;
		}

		// undo short castle black
		if ( piece == -6 && from == 84 && to == 82 ) {
			Board[81] = -2;
			Board[84] = -6;
			Board[82] = FREE;
			Board[83] = FREE;
			BlackCastled = false;
		}

		// undo long castle white
		if ( piece == 6 && from == 14 && to == 16 ) {
			Board[14] = 6;
			Board[18] = 2;
			Board[16] = FREE;
			Board[15] = FREE;
			WhiteCastled = false;
		}

		// undo long castle black
		if ( piece == -6 && from == 84 && to == 86 ) {
			Board[84] = -6;
			Board[88] = -2;
			Board[86] = FREE;
			Board[85] = FREE;
			BlackCastled = false;
		}

		// reset queen to pawn
		if ( Queened[MoveNumber] ) { Board[From[MoveNumber]] = ( Board[From[MoveNumber]] < 0 ? -1 : 1 ); }
	}

	private void swapSides() {
		SideToMove = ( SideToMove == WHITE ? BLACK : WHITE );
		OtherSide = ( OtherSide == WHITE ? BLACK : WHITE );
		MinScore = -MinScore;
	}

	private void setAttackedSquares( int side ) {
		// use to check king safety
		// space controlled
		// center
		boolean swapped = false;
		int d = 0;
		int sq = 0;

		if ( SideToMove != side ) { 
			swapSides(); 
			swapped = true;
		}

		int p = nextPos( );

		// clear attacked squares
		for( int i=11; i<=88; i++ ) { AttackedSquares[i] = 0; }

		// look at each move and remember attacked squares
		while( p > 0 ) {
			d = nextDir( p );

			while( d > 0 ) {
				d = nextDir( p,d );
				sq = d/100;
				if ( onBoard(sq) ) { AttackedSquares[sq] ++; }
			}
			p = nextPos(p);
		}

		if ( swapped ) { swapSides(); }
	}

	private String putOnBestMove( ) {
		int p = BsfFrom[MoveNumber];
		int d = BsfDir[MoveNumber];

		// for highlighting
		Chess.MovedFrom = p;
		Chess.MovedTo = BsfTo[MoveNumber];

		return putOnMove( p,d );
	}

	private int scoreBoard() {
		int score = 0;

		// add up material
		for( int p=11; p<=88; p++ ) {
			if ( whitePiece(p) ) { score += pieceValues[ Board[p] ] * 100; }
			if ( blackPiece(p) ) { score -= pieceValues[ Math.abs(Board[p]) ] * 100; }

			// doubled pawns
			if ( Board[p] == 1 && Board[p-10] == 1 ) { score -= 10; }
			if ( Board[p] == -1 && Board[p-10] == -1 ) { score += 10; }
		}

		// moved center pawns
		if ( Board[24] == FREE ) { score += 10; }					
		if ( Board[25] == FREE ) { score += 10; }					
		if ( Board[74] == FREE ) { score -= 10; }					
		if ( Board[75] == FREE ) { score -= 10; }					

		// pieces developed
		if ( Board[33] == 3 ) { score += 8; }	// knights
		if ( Board[36] == 3 ) { score += 8; }					
		if ( Board[63] == -3 ) { score -= 8; }					
		if ( Board[66] == -3 ) { score -= 8; }					

		if ( Board[13] != 4 ) { score += 5; }	// bishops				
		if ( Board[16] != 4 ) { score += 5; }					
		if ( Board[83] != -4 ) { score -= 5; }					
		if ( Board[83] != -4 ) { score -= 5; }					

		// castled
		if ( WhiteCastled ) { score += 40; }
		if ( BlackCastled ) { score -= 40; }

		// keep queen back
		if ( MoveNumber < 14 ) {
			if ( Board[15] == 5 ) { score += 20; }	
			if ( Board[85] == -5 ) { score -= 20; }	
		}

		// space and center
		setAttackedSquares( BLACK );
		for( int p=11; p<=48; p++ ) {
			if ( AttackedSquares[p] > 0 ) { 
				score--;
				if ( p >= 43 && p <= 46 || p >=33 && p <= 36 ) { score --; }
			}
		}
		setAttackedSquares( WHITE );
		for( int p=51; p<=88; p++ ) {
			if ( AttackedSquares[p] > 0 ) { 
				score++;
				if ( p >= 53 && p <= 56 || p >=63 && p <= 66 ) { score ++; }
			}
		}

		// castled
		// pawn struct - doubled, trippled, passed, pp, chains, open files, rooks on files

		// rnd bit
		score += (int)(Math.random() * (LevelRnd[Chess.Level]) );
	
		// some variation in the opening
		if ( MoveNumber < 12 ) { score += (int)(Math.random() * 10 ); }

		return score;
	}

	public void mouseReleased (MouseEvent me) {} 
	public void mouseEntered (MouseEvent me) {}
	public void mouseExited (MouseEvent me) {}
	public void mouseClicked (MouseEvent e) { }

	public void mousePressed (MouseEvent e) {
		int x = (e.getX()-BoardOffset) / 60 + 1;
		int y = (e.getY()-BoardOffset) / 60 + 1;
		int p = y*10 +x;
		int piece = 0;

		if ( Chess.TestMode==1) { System.out.println( "x=" + e.getX() + " y="+e.getY() ); }

		if ( Chess.GameMode != HUMAN_TO_MOVE && Chess.GameMode != STALEMATE && Chess.GameMode != CHECKMATE ) {
			return;
		}

		Chess.DisplayMsg = "";

		// buttons
		if ( x >= 10 ) {
			if ( y == 2 && Chess.MoveNumber > 0 ) {
				Chess.takeOffMove();
				Chess.swapSides();
				Chess.GameMode = HUMAN_TO_MOVE;
				paint(g);
			} else if ( y == 3 && Chess.GameMode == HUMAN_TO_MOVE ) {
				Chess.GameMode = Chess.COMP_TO_MOVE;
				paint(g);
			} else if ( y == 4 ) {
				Chess.startGame();
				paint(g);
			} else if ( y == 5 ) {
				Chess.TestMode = (Chess.TestMode + 1) % 3;
				Chess.DisplayMsg = "Test mode "+Chess.TestMode;
				paint(g);
			} else if ( y == 8 ) {
				if ( e.getX() < 600 ) {
					WhiteOnTop = ! WhiteOnTop;
				} else if ( e.getX() > 665 ) {
					Chess.Level = ( Chess.Level + 1 ) % (LevelDepth.length);
				} else {
					ShowCoord = ! ShowCoord;
				}
				paint(g);
			}
			return;
		}

		if ( ! WhiteOnTop ) { p = 99 - p; }

		// tmp issue when reversed
		if ( Chess.GameMode == HUMAN_TO_MOVE && Chess.onBoard(p) ) {
			if ( Chess.ourPiece(p) ) {
				piece = Math.abs( Board[ p ] );
				Chess.HumanMove = "" + pieceCodes[piece] + getCoord(p);
				Chess.MovedFrom = p;
				Chess.MovedTo = 0;
				paint(g);
			} else if ( Chess.HumanMove.length() == 0 ) {
				badHumanMove( "Click your piece first" );
			} else {
				// build move
				Chess.HumanMove += ( Chess.opoPiece(p) ? "*":"-") + getCoord(p);
				Chess.MovedTo = p;

				// try all moves, if move matches human move then play it else nothing
				Chess.findNextMove( 0,1,false,true,0,g );
				if ( Chess.MovedTo > 0 && ! Chess.finished() ) { Chess.GameMode = COMP_TO_MOVE; }
				Chess.HumanMove = "";
				paint(g);
			}
		}
	}
}
